/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.hud.impl;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.client.hud.Position;
import com.alrex.parcool.common.action.impl.CatLeap;
import com.alrex.parcool.common.action.impl.Dodge;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.event.TickEvent;

@OnlyIn(value=Dist.CLIENT)
public class StaminaHUD
extends GuiComponent {
    public static final ResourceLocation STAMINA = new ResourceLocation("parcool", "textures/gui/stamina_bar.png");
    private final Supplier<Position> pos;
    private float shadowScale = 1.0f;
    private int renderGageType = 0;
    private int renderGageTick = 0;

    public StaminaHUD(Supplier<Position> pos) {
        this.pos = pos;
    }

    public void onTick(TickEvent.ClientTickEvent event, LocalPlayer player) {
        if (++this.renderGageTick >= 5) {
            this.renderGageTick = 0;
            if (++this.renderGageType > 2) {
                this.renderGageType = 0;
            }
        }
    }

    public void render(ForgeGui gui, PoseStack stack, float partialTick, int width, int height) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (player.m_7500_()) {
            return;
        }
        IStamina stamina = IStamina.get((Player)player);
        Parkourability parkourability = Parkourability.get((Player)player);
        if (stamina == null || parkourability == null) {
            return;
        }
        if (((Boolean)ParCoolConfig.CONFIG_CLIENT.infiniteStamina.get()).booleanValue() && parkourability.getActionInfo().isInfiniteStaminaPermitted()) {
            return;
        }
        int boxWidth = 91;
        int boxHeight = 17;
        Tuple<Integer, Integer> pos = this.pos.get().calculate(91, 17, width, height);
        float staminaScale = (float)stamina.get() / (float)stamina.getActualMaxStamina();
        float coolTimeScale = Math.min(parkourability.get(Dodge.class).getCoolDownPhase(), parkourability.get(CatLeap.class).getCoolDownPhase());
        if (staminaScale < 0.0f) {
            staminaScale = 0.0f;
        }
        if (staminaScale > 1.0f) {
            staminaScale = 1.0f;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)STAMINA);
        StaminaHUD.m_93133_((PoseStack)stack, (int)((Integer)pos.m_14418_()), (int)((Integer)pos.m_14419_()), (float)0.0f, (float)0.0f, (int)93, (int)17, (int)128, (int)128);
        if (!stamina.isExhausted()) {
            StaminaHUD.m_93133_((PoseStack)stack, (int)((Integer)pos.m_14418_()), (int)((Integer)pos.m_14419_()), (float)0.0f, (float)102.0f, (int)((int)Math.ceil(92.0f * coolTimeScale)), (int)17, (int)128, (int)128);
            StaminaHUD.m_93133_((PoseStack)stack, (int)((Integer)pos.m_14418_()), (int)((Integer)pos.m_14419_()), (float)0.0f, (float)85.0f, (int)(Math.round(16.0f + 69.0f * this.shadowScale) + 1), (int)12, (int)128, (int)128);
            StaminaHUD.m_93133_((PoseStack)stack, (int)((Integer)pos.m_14418_()), (int)((Integer)pos.m_14419_()), (float)0.0f, (float)(17 * (this.renderGageType + 1)), (int)(Math.round(16.0f + 69.0f * staminaScale) + 1), (int)12, (int)128, (int)128);
        } else {
            StaminaHUD.m_93133_((PoseStack)stack, (int)((Integer)pos.m_14418_()), (int)((Integer)pos.m_14419_()), (float)0.0f, (float)68.0f, (int)(Math.round(16.0f + 69.0f * staminaScale) + 1), (int)17, (int)128, (int)128);
        }
        this.shadowScale = staminaScale - (staminaScale - this.shadowScale) / 1.1f;
    }
}

